-- this one only has two items.
local framePref = ThemePrefs.Get("LifeMeterBarOver");

local curIndex;
if framePref == "norm" then curIndex = 1;
elseif framePref == "shrink" then curIndex = 2;
else curIndex = 2;
end;

local frames = {
	"norm",
	"shrink"
};

local frameBGPref = string.format("%02i",tonumber(ThemePrefs.Get("LifeFrame")));

local t = Def.ActorFrame{
	InitCommand=cmd(x,SCREEN_WIDTH+SCREEN_CENTER_X;y,(SCREEN_CENTER_Y*0.5)+8);
	ShowCommand=cmd(stoptweening;bounceend,0.5;x,math.floor(WideScale(SCREEN_CENTER_X*1.425,SCREEN_CENTER_X*1.35)));
	HideCommand=cmd(stoptweening;bouncebegin,0.5;x,SCREEN_WIDTH+SCREEN_CENTER_X);
	MenuStateChangedMessageCommand=function(self,param)
		if param.NewState == "MenuState_LifeMeterBarOver" then
			self:playcommand("Show")
		elseif param.NewState == "MenuState_Main" then
			self:playcommand("Hide")
		end;
	end;
	Def.Actor{
		Name="LifeMeterBarOverController";
		PlayerMenuInputMessageCommand=function(self,param)
			if param.MenuState == "MenuState_LifeMeterBarOver" then
				if param.Input == "Start" then
					ThemePrefs.Set("LifeMeterBarOver",frames[curIndex]);
					-- okay time to go back to the main menu
					MESSAGEMAN:Broadcast("MenuStateChanged",{NewState = "MenuState_Main"});
				elseif param.Input == "Back" then
					-- go back to main menu
					MESSAGEMAN:Broadcast("MenuStateChanged",{NewState = "MenuState_Main"});
				else
					if param.Input == "Left" or param.Input == "Up" then
						MESSAGEMAN:Broadcast("PreviousLifeMeterBarOver");
					elseif param.Input == "Right" or param.Input == "Down" then
						MESSAGEMAN:Broadcast("NextLifeMeterBarOver");
					end;
				end;
			end;
		end;
		NextLifeMeterBarOverMessageCommand=function(self)
			local prevIndex = curIndex;
			if curIndex == 1 then curIndex = 2;
			elseif curIndex == 2 then curIndex = 1;
			end;
			MESSAGEMAN:Broadcast("LifeMeterBarOverChanged",{NewLifeMeterBarOver = frames[curIndex], NewIndex = curIndex, OldIndex = prevIndex});
		end;
		PreviousLifeMeterBarOverMessageCommand=function(self)
			local prevIndex = curIndex;
			if curIndex == 1 then curIndex = 2;
			elseif curIndex == 2 then curIndex = 1;
			end;
			MESSAGEMAN:Broadcast("LifeMeterBarOverChanged",{NewLifeMeterBarOver = frames[curIndex], NewIndex = curIndex, OldIndex = prevIndex});
		end;
	};

	LoadActor( "_lifeframe "..frameBGPref )..{
		InitCommand=cmd(x,4;y,52);
		BeginCommand=function(self)
			self:playcommand( curIndex == 1 and "GainFocus" or "LoseFocus" );
		end;
		GainFocusCommand=cmd(stoptweening;linear,0.3;diffuse,color("1,1,1,1"));
		LoseFocusCommand=cmd(stoptweening;linear,0.3;diffuse,color("0.8,0.8,0.8,0.5"));
		LifeMeterBarOverChangedMessageCommand=function(self,param)
			if param.OldIndex == 1 then
				self:playcommand("LoseFocus");
			end;
			if param.NewIndex == 1 then
				self:playcommand("GainFocus");
			end;
		end;
		LifeFrameChangedMessageCommand=function(self,param)
			self:Load( THEME:GetPathB("ScreenPHOTwON","overlay/_lifeframe "..param.NewLifeFrame) );
		end;
	};
	LoadActor(THEME:GetPathG("LifeMeterBar","Over/norm"))..{
		InitCommand=cmd(x,-8;y,50);
		BeginCommand=function(self)
			self:playcommand( curIndex == 1 and "GainFocus" or "LoseFocus" );
		end;
		GainFocusCommand=cmd(stoptweening;linear,0.3;diffuse,color("1,1,1,1"));
		LoseFocusCommand=cmd(stoptweening;linear,0.3;diffuse,color("0.8,0.8,0.8,0.5"));
		LifeMeterBarOverChangedMessageCommand=function(self,param)
			if param.OldIndex == 1 then
				self:playcommand("LoseFocus");
			end;
			if param.NewIndex == 1 then
				self:playcommand("GainFocus");
			end;
		end;
	};

	LoadActor( "_lifeframe "..frameBGPref )..{
		InitCommand=cmd(x,4;y,224);
		BeginCommand=function(self)
			self:playcommand( curIndex == 2 and "GainFocus" or "LoseFocus" );
		end;
		GainFocusCommand=cmd(stoptweening;linear,0.3;diffuse,color("1,1,1,1"));
		LoseFocusCommand=cmd(stoptweening;linear,0.3;diffuse,color("0.8,0.8,0.8,0.5"));
		LifeMeterBarOverChangedMessageCommand=function(self,param)
			if param.OldIndex == 2 then
				self:playcommand("LoseFocus");
			end;
			if param.NewIndex == 2 then
				self:playcommand("GainFocus");
			end;
		end;
		LifeFrameChangedMessageCommand=function(self,param)
			self:Load( THEME:GetPathB("ScreenPHOTwON","overlay/_lifeframe "..param.NewLifeFrame) );
		end;
	};
	LoadActor(THEME:GetPathG("LifeMeterBar","Over/shrink"))..{
		InitCommand=cmd(x,-8;y,222);
		BeginCommand=function(self)
			self:playcommand( curIndex == 2 and "GainFocus" or "LoseFocus" );
		end;
		GainFocusCommand=cmd(stoptweening;linear,0.3;diffuse,color("1,1,1,1"));
		LoseFocusCommand=cmd(stoptweening;linear,0.3;diffuse,color("0.8,0.8,0.8,0.5"));
		LifeMeterBarOverChangedMessageCommand=function(self,param)
			if param.OldIndex == 2 then
				self:playcommand("LoseFocus");
			end;
			if param.NewIndex == 2 then
				self:playcommand("GainFocus");
			end;
		end;
	};
};

return t;